<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" encoding="utf-8"/>

<xsl:template match="/MEREPORT">
	<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
		<head>
			<title>Images</title>
			<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
			<link rel="stylesheet" type="text/css">
				<xsl:attribute name="href">
					<xsl:value-of select="csspath"/>
				</xsl:attribute>
			</link>
		</head>
		<body>
			<div id="content">		
				<h1>Images</h1>
				<xsl:call-template name="images"/>
			</div>
		</body>
	</html>
</xsl:template>

<xsl:template name="images">
	<table>
		<tr>
			<th>id</th>
			<th>dateTaken</th>
			<th>isPrivate</th>
			<th>latitude</th>
			<th>longitude</th>
			<th>orientation</th>
			<th>mimeType</th>
			<th>description</th>
			<th>picasaId</th>
			<th>displayName</th>
			<th>title</th>
			<th>localpath</th>
		</tr>
		
		<xsl:for-each select="image">
			<tr>
				<xsl:attribute name="class">
					<xsl:if test="position() mod 2 = 0">zebra1</xsl:if>
					<xsl:if test="position() mod 2 = 1">zebra2</xsl:if>
				</xsl:attribute>	
						
				<td><xsl:value-of select="@id"/></td>
				<td><xsl:value-of select="@dateTaken"/></td>
				<td><xsl:value-of select="@isPrivate"/></td>
				<td><xsl:value-of select="@latitude"/></td>
				<td><xsl:value-of select="@longitude"/></td>
				<td><xsl:value-of select="@orientation"/></td>
				<td><xsl:value-of select="@mimeType"/></td>
				<td><xsl:value-of select="description"/></td>
				<td><xsl:value-of select="picasaId"/></td>
				<td><xsl:value-of select="displayName"/></td>
				<td><xsl:value-of select="title"/></td>
				<td><xsl:value-of select="localpath"/></td>
			</tr>
		</xsl:for-each>
		
	</table>
</xsl:template>

</xsl:stylesheet>

